--------------------------------------------------------------------
--            SymCACP Search Module 1         Golly bits chaos
-- Symmetrical CA Control Panel   symCACPsrch
-- End is determined when a band is broken
---------------------------------------------------------------------
--  P. Rendell   07/12/2022
--------------------------------------------------------------------
--------------------------------------------------------------------
local m ={}		-- class main
local getOsc = false
m.result = ''
local g = golly()
local gr = require("buildUni") 
local TraceLay1, TraceLay2, TraceLay3
local traceBanLay1Name = "TraceBandLayer 1"
local traceBanLay2Name = "TraceBandLayer 2"
local traceBanLaynName = "TraceBandLayer n"
local chaosSrchBuff = 20
local isle_Start 	-- function
local isle_cellScan 	-- function
local getUni		-- function
local initUni		-- function

--------------------------------------------------------------------------------
local function bool2txt(b)
   if b then
      return 'true'
   end
   return 'false'
end
--------------------------------------------------------------------------------
local function strCC(s1,s2)
   local res = ''
   if  s2 then
      if s1 then
         res = s1..s2
      else
         res = '**NIL**'..s2
      end
   elseif s1 then
      res = s1..'**NIL**'
   else
      res = '**NIL*NIL**'
   end
   return res
end

--------------------------------------------------------------------
local function EmtpyPT()
   return({x = 0, y = 0, len = 0, cnt = 0, yDec = true })
end
--------------------------------------------------------------------
-- init Function

function m.init(logFile, srchType)
   m.logFile = logFile
   m.srchType = srchType
   m.logFile:write("search-band:Got Log File, Search Type "..srchType.."\n")
   if (srchType:sub(1,5) == "BREAK") then				-- "BREAK4" for orthogonal island band in isle_cellScan
      getUni = m.getUniBreak
   else
      getUni = m.getUniChaos
   end
   getOsc = (srchType == "OSC")
end
   
   
--==================================================================
   -------------------------------------------------------------------

function m.SetupTrace()
   local NormalLay = g.getlayer()
   while ( g.numlayers() > 1 ) do
      g.setlayer(g.numlayers() - 1)
      g.dellayer()
   end    
   TraceLay1 = g.addlayer()
   g.setname(traceBanLay1Name)
   TraceLay2 = g.addlayer()
   g.setname(traceBanLay2Name)
   g.setlayer(NormalLay)	
end
-------------------------------------------------------------------

function m.ClearTrace()
   local NormalLay = g.getlayer()
   g.setlayer(TraceLay1)	
   g.select( {0,0,1,1} )
   g.clear(1)
   g.clear(0)
   g.select( {} )
   g.setlayer(TraceLay1)	
   g.select( {0,0,1,1} )
   g.clear(1)
   g.clear(0)
   g.select( {} )
   g.setlayer(NormalLay)	
end
-------------------------------------------------------------------

function m.DisplayIsland(isle, isleID)
   local NormalLay = g.getlayer()
   if (isleID == 1) then
      g.setlayer(TraceLay1)	
      g.setcolors({1,255,0,0})  -- 1-red
   elseif (isleID < 3) then
      g.setlayer(TraceLay2)	
      g.setcolors({1,0,255,0})  -- 2-green
   else
      if (not TraceLay3) then	-- dislay a third island in layer 3
         g.setlayer(g.numlayers() - 1)
      else
         g.setlayer(TraceLay3)
         g.dellayer()
      end
      TraceLay3 = g.addlayer()
      g.setname(traceBanLaynName)
      g.setcolors({1,0,0,255})  -- 2-blue
   end   
   cLst = isle.cellLst
   local cnt = 10
   local no = 0
   while (cLst) do
--      m.logFile:write("DisplayIsland: "..cLst.cellI..","..cLst.cellJ.."\n")
      g.setcell(cLst.cellI, cLst.cellJ, 1)
      cLst = cLst.next
   end
   g.setlayer(NormalLay)	
   m.logFile:flush()
end
-------------------------------------------------------------------
--==================================================================

------------------------------------------------------------
--   Island parts to search band 
------------------------------------------------------------

local isleCnt = 0
local isleNoMax = 0
local isleLstStart = nil
local cellIsleNo = {}
local cellScanned = {}
local isleBand= {}
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
local function initIsle()
   m.logFile:write("initIsle gen "..g.getgen().."\n")
   isleCnt = 0
   isleNoMax = 0
   isleLstStart = nil
   cellIsleNo = {}
   cellScanned = {}
   for i = -(m.width//2), (m.width-1)//2 do
      cellIsleNo[i] = {}
      cellScanned[i] = {}
   end
   isleBand= {}
end
-----------------------------------------------------------------------------------------------
local function incX(x)
   local nx = x+1
   if (nx > (m.width-1)//2) then
      nx = -(m.width//2)
   end
   return(nx)
end
-----------------------------------------------------------------------------------------------
local function incY(y)
   local ny = y+1
   if (ny > (m.hight-1)//2) then
      ny = -(m.hight//2)
   end
   return(ny)
end
-----------------------------------------------------------------------------------------------
local function decY(y)
   local ny = y-1
   if (ny < -(m.hight//2)) then
      ny = (m.width-1)//2
   end
   return(ny)
end
-----------------------------------------------------------------------------------------------
local function decX(x)
   local nx = x-1
   if (nx < -(m.width//2)) then
      nx = (m.width-1)//2
   end
   return(nx)
end
-------------------------------------------------------------------
-------------------------------------------------------------------
-------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------

local function isle_ListAddCell(isleLst, cellI, cellJ, cellState)
   if (cellIsleNo[cellI][cellJ]) then
      if (cellIsleNo[cellI][cellJ]~= isleLst.isleNo) then
         m.logFile:write("*** addCell attempt add to list twice cellKey: ")
         m.logFile:flush()
         m.logFile:write(cellI..","..cellJ.." island: "..cellIsleNo[cellI][cellJ].." offering to island ")
         m.logFile:flush()
         m.logFile:write(isleLst.isleNo.."\n")
         m.logFile:flush()
      end
   else
      if (isleLst == nil) then
         m.logFile:write("*** addCell attempt add to a nil list\n")
      else
         if (isleLst.cellState ~= cellState) then
            m.logFile:write("*** addCell attempt add cell of the wrong state\n")
         else
            cellIsleNo[cellI][cellJ] = isleLst.isleNo
            isleLst.cellLst = {next = isleLst.cellLst, cellI = cellI, cellJ = cellJ}
            isleLst = isle_cellScan(cellI, cellJ, cellState, isleLst)
         end
      end
   end
   return(isleLst)
end
-----------------------------------------------------------------------------------------------

function isle_cellScan(ip, jp, lstCellstate, iLst)
   if (not cellScanned[ip][ij]) then 
      if (iLst) then 
         local neighbours
         if (m.srchType == "BREAK4") then
            neighbours = {{decX(ip),jp,       m.xEnd},   {incX(ip),jp,       m.xStart},
                          {ip,      decY(jp), m.height}, {ip,      incY(jp), m.height} }
         else
            neighbours = {{decX(ip),jp,       m.xEnd},   {incX(ip),jp,       m.xStart},
                          {ip,      decY(jp), m.height}, {ip,      incY(jp), m.height},
                          {decX(ip),decY(jp), m.xEnd},   {incX(ip),decY(jp), m.xStart}, 
                          {decX(ip),incY(jp), m.xEnd},   {incX(ip),incY(jp), m.xStart} }
         end
         for ind,coods in pairs(neighbours) do
            local iu = coods[1]
            if (iu ~= coods[3]) then
               local ju = coods[2]
               local cellstate = g.getcell(iu, ju)
               if ( (cellIsleNo[iu][ju] == nil) and (cellstate == lstCellstate)) then
                  iLst = isle_ListAddCell(iLst, iu, ju, cellstate)
               end
            end
         end
      else
         m.logFile:write("*** isle_cellScan attempt scan "..ip..","..jp.." for nil iLst\n")
      end
      cellScanned[ip][jp] = true
   end
   return(iLst)
 end   
-----------------------------------------------------------------------------------------------

local function Isle_New(cellI, cellJ, cellState)
   if (cellIsleNo[cellI][cellJ]) then
      m.logFile:write("*** Isle_New attempt add to list twice was island ")
      m.logFile:flush()
      m.logFile:write(cellIsleNo[cellI][cellJ].." offering to new island ".."\n")
      m.logFile:flush()
   else
      isleNoMax = isleNoMax + 1
      isleCnt = isleCnt + 1
      local lst = isleLstStart
      isleLst = {next = nil, prev = nil, isleNo = isleNoMax, cellState = cellState, cellLst = nil}
      isleLst = isle_ListAddCell(isleLst, cellI, cellJ, cellState)
   end
   return(isleLst)
end
-----------------------------------------------------------------------------------------------

function isle_Start(x0)
   --  start all the island bands 
   local runLen = 1
   initIsle()
   m.xStart = x0
   m.xEnd = decX(x0)
   for yz = -(m.hight//2), (m.hight-1)//2 do
      local state = g.getcell(x0,yz)
      if ( not isleBand[state] ) then
         if ( not cellIsleNo[x0][yz] ) then
            local isleLst = Isle_New(x0, yz, state)
--            m.ClearTrace()
--            m.DisplayIsland(isleLst, state)
            for yz = -(m.hight//2), (m.hight-1)//2 do
               if ( ( cellIsleNo[m.xEnd][yz] == isleLst.isleNo) and (cellIsleNo[m.xStart][yz] == isleLst.isleNo)) then
                  isleBand[state] = true
                  m.logFile:write("isle_Start band found y "..yz.." state "..state.."\n")
                  break
               end
            end
         end
      end
   end
   local bandcnt = 0
   for i,k in pairs(isleBand) do
      bandcnt = bandcnt +1
   end
   m.logFile:write("isle_Start finished "..bandcnt.." bands found "..g.getgen().." generations\n")
   return(isleBand)
end
-----------------------------------------------------------------------------------------------
   
--==================================================================
--------------------------------------------------------------------
--------------------------------------------------------------------
local function universeSave()
   local s = {}
   s.result = 'none'
   s.pt = EmtpyPT()
   s.restore =   function()
                    g.select({0,0,1,1})
   		       g.clear(1)
   		       g.clear(0)
   		       g.select({})
                    g.putcells(s.universe)
                    g.setgen(s.gen)
                 end
   s.setResult = function (res)
                    s.result = res
                    if res == 'killed' then
                       m.result = 'killed'
                    end
                 end
   s.getChanges =  function(o)	-- return the number of cells which have different states in uni s and uni o
                 end        
   s.gen = tonumber(g.getgen())
   s.pop = tonumber(g.getpop())
   s.pop = math.min(s.pop, m.maxCells - s.pop)
   s.universe = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
   return s
end
--------------------------------------------------------------------
--------------------------------------------------------------------
function m.isCurrentUni(uni)   
   local newPat = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
   local found = false
   if #newPat == #uni.universe then
      found = true
      for j = 1, #newPat do
         if newPat[j] ~= uni.universe[j] then
            found = false
            break
         end
      end
   end
   return found   
end
--------------------------------------------------------------------
--------------------------------------------------------------------

   function m.getUniOsc()
      local event
      local uni = universeSave()
      if m.oscPeriod > 0 then
          g.run(m.oscPeriod)
	  if m.isCurrentUni(uni) then
	     uni.setResult('osc')
	  end
         uni.restore()
      else
         local pop = g.getpop()
         if (m.oscLengMin>1) then 
            g.run(m.oscLengMin-1)
         end
         for i = 1, (1+m.oscLengMax-m.oscLengMin)*2+1 do
            g.run(1)
            event = g.getevent()
            if (event:find("^key") or event:find("^oclick"))  then
               m.logFile:write("getUniOsc stoped by user action gen "..uni.gen.."\n")
               uni.setResult("killed")
               m.keepGoing = false
               break
            end
            if (pop == g.getpop()) and m.isCurrentUni(uni) then
	        uni.setResult('osc')
	        m.oscPeriod = i+m.oscLengMin-1
	        break
	    end
         end
         uni.restore()
      end
      m.logFile:write("getUniOsc gen "..uni.gen.." oscLeng "..m.oscLengMin..","..m.oscLengMax.." oscPeriod "..m.oscPeriod.."\n")
      return uni
   end
--------------------------------------------------------------------
-- New  version of getuniverse which stops when a band breaks
-- will work for 2 bands in H1D8 if it goes to chaos but not if chaos collapses
-- currently only supports one band of each state but for chaos collapse we have
-- 2 bands of the same state.
-- Require extra check as sometimes the bands reform. So we will only accept as break as genuine
-- if it does not reform within bufferCnt = x generations.

function m.getUniBreak(oldPT)
   local event
   local uni = universeSave()
   local MaxIsles = {}
--   m.SetupTrace()
   g.update()
   m.logFile:write("getUniBreak gen "..g.getgen().."\n")
   local bufferCnt = 20
   local bandcnt = 0
   while (bufferCnt > 0) do
      MaxIsles = isle_Start(0)
      bandcnt = 0
      for i,k in pairs(MaxIsles) do
         bandcnt = bandcnt +1
      end
      if (bandcnt==2) then
         bufferCnt = 0
      else
         bufferCnt = bufferCnt -1
         g.run(1)
      end
   end
   if (bandcnt < 2) then
      uni.setResult('brk')
   end
   uni.restore()
   m.logFile:write("getUniBreak gen "..g.getgen().." bands "..bandcnt.."\n")
   return uni
end
--------------------------------------------------------------------

--------------------------------------------------------------------
-- CHAOS version. Assume that we have chaos if there is no long runs of a single state greater than a predetermined constant.
-- This is an arbitary constant, we could use some fancy analyis of the probability of non chaos long run lengths - COMPLEX
-- One problem is that binary search process realy only works with an absolute change in measure but the long run length is not
-- an abslute, Like the BREAK method we need some extra check. Here we want the first occurance of a short runlength to be taken
-- as the result.  We need to identify chaos even if we hapen to land on something that meets the non chaos criteria.

-- need chaosSrchBuff non chaos in a row to say this is not chaos then adjust at the end to find actual transition

function m.getUniChaos(oldPT)
   m.logFile:write("getUniChaos gen "..g.getgen().."\n")
   local uni = universeSave()
   uni.pt = oldPT
   m.getChaosUni(uni, oldPT)
   local tres = uni.result
   local chaosCnt = 0
   local checkpt = "this"..oldPT.x   
   if (uni.result ~= 'chaos') then
      for cnt = 1,chaosSrchBuff do
         g.run(1)
         local uniTmp = universeSave()
         m.getChaosUni(uni, oldPT)
         if (uniTmp.result == 'chaos') then
            chaosCnt = chaosCnt+1
         end
      end
      if ( (chaosCnt * 2) > chaosSrchBuff) then
         uni.setResult('chaos')
      end
   end
   uni.restore()
   m.logFile:write("getUniChaos gen "..g.getgen().." result "..uni.result.." temp result "..tres.." chaosCnt "..chaosCnt.." checks\n")
   return uni
end
--------------------------------------------------------------------

function m.getUniChaosAdjust(uni, oldPT)
   uni.setResult('none')
   m.getChaosUni(uni, oldPT)
   local origGen = uni.gen
   m.logFile:write("getUniChaosAdjust start  gen "..g.getgen().." result "..uni.result.."\n")         
   if (uni.result ~= 'chaos') then
      for cnt = 1,chaosSrchBuff do
         g.run(1)
         local uniTmp = universeSave()
         m.getChaosUni(uniTmp, oldPT)
         if (uniTmp.result == 'chaos') then
            m.logFile:write("getUniChaosAdjust step "..cnt.." gen "..g.getgen().." result "..uni.result.." origGen "..origGen.."\n")         
            uni = uniTmp
            uni.setResult('chaos')
            break
         end
      end
   end
   uni.restore()
   m.logFile:write("getUniChaosAdjust gen "..g.getgen().." result "..uni.result.." origGen "..origGen.."\n")
   return(uni)
end
--------------------------------------------------------------------

function m.getChaosUni(uni, oldPT)
   local event
   local x,y
        
   function chaosFound(pt)
      return( (pt.len > 0) and (pt.len < m.minRunLength) and (pt.cnt > m.minPTcnt) )
   end
   
   function checkOldPT(oldPT)
      local ok = (not chaosFound(oldPT)) and (oldPT.len ~= 0)
      local x = oldPT.x
      local y = oldPT.y
      local state = g.getcell(x, y)
      local delta = 1
      while(ok and (delta + 1) < oldPT.len) do
         delta = delta + 1
         x = incX(x)
         if (oldPT.yDec) then
            y = decY(y)
         end
         ok = (state == g.getcell(x, y))
      end
      return(ok)
   end
   
   function findLongRunCentre(yDec)
      local pt = EmtpyPT()
      local x,y,len,x0,y0
      pt.yDec = yDec
      for i = -(m.width//2), (m.width-1)//2 do         
         x = i
         y = 0
         x0 = x;y0 = y
         len = 1
         state = g.getcell(x,y)
         for n = 1, m.width do
            x = incX(x)
            if (yDec) then
               y = decY(y)
            end
            if ( (state == g.getcell(x,y)) and ( (not yDec) or (state == g.getcell(incX(x),y))) ) then
               len = len +1
            else
               if (len > pt.len) then
                  m.logFile:write("run break "..x0..","..y0.." : "..x..","..y.." len "..len.."\n")
                  pt.x = x
                  pt.y = y
                  pt.len = len
                  pt.cnt = 1
               elseif (len == pt.len) then
                  pt.cnt = pt.cnt+1
               end
               x0 = x;y0 = y
               state = g.getcell(x,y)
               len = 1
               if ((m.width - n) < pt.len) then
                  break
               end
            end
         end
         if (len > pt.len) then
            m.logFile:write("run break "..x0..","..y0.." : "..x..","..y.." len "..len.."\n")
	       pt.x = x
	       pt.y = y
	       pt.len = len
	       pt.cnt = 1
	   end
      end
      g.update()
      return(pt)
   end
   
   if(uni.pop < m.minCellEmpty) then
      uni.setResult('osc')
   else
      if (checkOldPT(oldPT)) then
         uni.pt = oldPT
         m.logFile:write("getUniChaos gen "..uni.gen.." Old pt is still the same\n")
      else
         uni.pt = findLongRunCentre(oldPT.yDec)
         if (chaosFound(uni.pt)) then
            local otherPT = uni.pt
            uni.pt = findLongRunCentre(not uni.pt.yDec)
            if (chaosFound(uni.pt)) then
               uni.setResult('chaos')
            else
               if (otherPT.len > uni.pt.len) then
                  uni.pt.len =  otherPT.len
               end
            end
         end
      end
   end
   m.logFile:write("getUniChaos gen "..uni.gen.." pt x "..uni.pt.x.." y "..uni.pt.y.." uni.pt.len "..uni.pt.len.." uni.pt.cnt "..uni.pt.cnt.." result "..uni.result.."\n")
   m.logFile:flush()
   return uni
end
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------
function m.loopForBRK(step1)
   -- Determine if the end is reachable by looking broken band
   -- a broken band has no diagonal connection for the next ? generations
   -- this is easier to determine than a clear 2 cell gap.
   -- number needs to be bigger than 6
   local thisStep = math.floor(step1)
   local universeBefore, universeAfter
   local event
   m.oscPeriod = -1
   
--      m.logFile:write("loopForBRK started 1 step1 "..step1.."\n")
   m.keepGoing = true

   universeBefore = getUni(EmtpyPT()) 
   m.logFile:write("loopForBRK started 2 step1 "..step1.."\n")
   universeAfter = universeBefore
   m.keepGoing = (universeBefore.result ~= 'brk') and (universeBefore.result ~= 'osc') and (universeBefore.result ~= 'chaos') 
       
   while m.keepGoing do 
      g.run(thisStep)
      g.update()
      if (getOsc) then 
         universeAfter = m.getUniOsc()
      else
         universeAfter = getUni(universeBefore.pt) 
      end
      if (universeAfter.result == 'brk') or (universeAfter.result == 'osc') or (universeAfter.result == 'chaos') then
         getOsc = getOsc or (universeAfter.result == 'osc')
         if thisStep > 1 then
            thisStep = math.max(1, (thisStep+1)//2 )
            m.logFile:write("loopForBRK backward thisStep "..thisStep.." gen "..universeBefore.gen.." max ".. m.maxGen.."\n")
            universeAfter = universeBefore
            universeAfter.restore()
         else							-- universeAfter is lowest brk universe
            --universeAfter.setResult('end')
            m.keepGoing = false
         end
      else				-- no brk found
         if (universeAfter.gen < m.maxGen) then
            thisStep = math.max(2,thisStep + thisStep//2)
            m.logFile:write("loopForBRK forward thisStep "..thisStep.." gen "..universeBefore.gen.." max ".. m.maxGen.."\n")
         else
            universeAfter.setResult("maxEx")
            m.keepGoing = false
            m.logFile:write("max exceeded finished gen "..universeAfter.gen.." max ".. m.maxGen.."\n")
         end
      end
      g.show("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.maxGen.." maxCells "..m.maxCells)
      m.logFile:write("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.maxGen.." maxCells "..m.maxCells..' kg '..bool2txt(m.keepGoing)..'\n')
      if m.keepGoing then
         event = g.getevent()
         if (event:find("^key") or event:find("^oclick")) then
            m.logFile:write("loopForBRK stoped by user action gen "..universeAfter.gen.." max gen ".. m.maxGen.."\n")
            universeAfter.setResult("killed")
            m.keepGoing = false
         end
      end
      universeBefore = universeAfter
      
   end
   universeBefore.restore()
   if (m.srchType == "CHAOS") then 
      universeAfter = m.getUniChaosAdjust(universeAfter, EmtpyPT())      
   end
   return universeAfter
end
--------------------------------------------------------------------
--------------------------------------------------------------------

function m.doFindEnd(seed, maxGen, step1)  -- called from SymCACP or SymCACPscript
   local ans="failed"
   m.seed = seed
   m.width = tonumber(g.getwidth())
   m.hight = tonumber(g.getheight())
   m.i0 = -(m.width//2)
   m.i1 = m.width + m.i0 - 1
   m.j0 = -(m.hight//2)
   m.j1 = m.hight + m.j0 - 1
   g.setbase(32)    
   m.maxCells = m.width * m.hight
   m.minCellEmpty = math.max(20,m.maxCells//10)
   m.minRunLength = 8
   m.minPTcnt = 0  --- math.max(2,m.width/10)
   m.maxGen = maxGen
   m.result = 'none'
   m.pop = -1
   m.oscLengMin = 1
   m.oscLengMax = 100

   local cmd = ""
   local MaxIsles = {}
   m.SetupTrace()
--   MaxIsles = isle_Start(0)
   m.logFile:write('initFind ('..seed..strCC(',',tostring(maxGen))
                               ..strCC(')->(',tostring(m.maxGen))
                               ..' minPTcnt='..m.minPTcnt..' minRunLength='..m.minRunLength..' minCellEmpty='..m.minCellEmpty
                               ..')\n')
   
   local Urule = g.getrule()
   if Urule:find(':') then
      local hexRule = Urule:sub(1,Urule:find(':')-1)
      m.logFile:write("FindEnd starting "..hexRule.."\n")
      if Urule:find('HEX') then
         hexRule = hexRule:gsub('HEX','H')
      else
         hexRule = gr.convBS2Hex(hexRule)
      end
      local uni = m.loopForBRK(step1)
      g.update()
      m.result = uni.result
      ans = "Finished: "..m.result.." "..hexRule.." "..seed.." "..m.width..","..m.hight.." gen "..uni.gen.." Osc period "..m.oscPeriod
      g.show(ans)
      m.logFile:write(ans.."\n")
      m.logFile:flush()
      m.pop = uni.pop
      if m.result == 'killed' then
         return 'killed'
      else
         return ans      
      end
   else
      g.show('** not a torus universe **')
      return 'Not Totus'
   end
   m.result = uni.result
   return ans  
end
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------

return m

--------------------------------------------------------------------
--                      	END OF FILE
--------------------------------------------------------------------
